/*
 * Decompiled with CFR 0.152.
 */
package uni.dcloud.io.uniplugin_reader;

import android.content.Context;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.util.Log;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.WXModule;
import com.zkteco.android.IDReader.WLTService;
import com.zkteco.android.biometric.core.device.BiometricDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.module.idcard.IDCardReader;
import com.zkteco.android.biometric.module.idcard.IDCardReaderFactory;
import com.zkteco.android.biometric.module.idcard.exception.IDCardReaderException;
import com.zkteco.android.biometric.module.idcard.meta.IDCardInfo;
import java.util.HashMap;
import uni.dcloud.io.uniplugin_lcprint.R;
import uni.dcloud.io.uniplugin_reader.PowerUtil;

public class IdModule
extends WXModule {
    private IDCardReader idCardReader;
    private final String idSerialName = "/dev/ttyS2";
    private final int idBaudrate = 115200;
    private MyTask myTask;
    private boolean bopen = false;
    private MediaPlayer mediaPlayer;

    @JSMethod(uiThread=false)
    public JSONObject initSDK() {
        Log.e((String)"TAG", (String)"initSDK: ");
        JSONObject data = new JSONObject();
        try {
            this.mediaPlayer = MediaPlayer.create((Context)this.mWXSDKInstance.getContext(), (int)R.raw.success);
            PowerUtil.power_uhf("1");
            Thread.sleep(100L);
            LogHelper.setLevel((int)2);
            HashMap<String, Object> idrparams = new HashMap<String, Object>();
            idrparams.put("param.key.serialname", "/dev/ttyS2");
            idrparams.put("param.key.baudrate", 115200);
            this.idCardReader = IDCardReaderFactory.createIDCardReader((Context)this.mWXSDKInstance.getContext(), (TransportType)TransportType.SERIALPORT, idrparams);
            if (this.idCardReader != null) {
                this.idCardReader.open(0);
                this.bopen = true;
            } else {
                this.bopen = false;
                data.put("code", (Object)"error");
            }
        }
        catch (IDCardReaderException e) {
            LogHelper.d((String)(e.getErrorCode() + "\n" + e.getMessage() + "\n" + e.getInternalErrorCode()));
            data.put("code", (Object)"error");
        }
        catch (InterruptedException e) {
            LogHelper.d((String)("error" + e.getMessage()));
            data.put("code", (Object)"error");
        }
        catch (Exception e) {
            LogHelper.d((String)("error" + e.getMessage()));
            data.put("code", (Object)"error");
        }
        data.put("code", (Object)"success");
        return data;
    }

    @JSMethod(uiThread=false)
    public void close() {
        try {
            this.cancelCycle();
            this.idCardReader.close(0);
            this.idCardReader.destroy();
            IDCardReaderFactory.destroy((BiometricDevice)this.idCardReader);
            PowerUtil.power_uhf("0");
        }
        catch (Exception e) {
            Log.e((String)"TAG", (String)"close: ");
        }
    }

    @JSMethod(uiThread=false)
    public void cycleReadCard() {
        if (this.myTask == null) {
            this.myTask = new MyTask();
            this.myTask.execute(new Integer[]{0});
        }
    }

    @JSMethod(uiThread=false)
    public void cancelCycle() {
        if (this.myTask != null) {
            this.myTask.cancel(true);
            this.myTask = null;
        }
    }

    @JSMethod(uiThread=false)
    public void sigleRead() {
        try {
            this.Authenticate();
            IDCardInfo idCardInfo = new IDCardInfo();
            boolean ret = this.idCardReader.readCard(0, 1, idCardInfo);
            if (ret) {
                this.readInfo(idCardInfo, ret);
            }
        }
        catch (IDCardReaderException e) {
            e.printStackTrace();
        }
    }

    public void readInfo(IDCardInfo idCardInfo, boolean ret) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Name", idCardInfo.getName());
        params.put("Sex", idCardInfo.getSex());
        params.put("Address", idCardInfo.getAddress());
        params.put("Birth", idCardInfo.getBirth());
        params.put("Id", idCardInfo.getId());
        params.put("Nation", idCardInfo.getNation());
        params.put("Depart", idCardInfo.getDepart());
        params.put("ValidityTime", idCardInfo.getValidityTime());
        if (idCardInfo.getPhotolength() > 0) {
            byte[] buf = new byte[WLTService.imgLength];
            if (1 == WLTService.wlt2Bmp(idCardInfo.getPhoto(), buf)) {
                params.put("Photo", buf);
            }
        }
        this.mediaPlayer.start();
        this.mWXSDKInstance.fireGlobalEventCallback("readInfo", params);
    }

    public boolean Authenticate() {
        try {
            this.idCardReader.findCard(0);
            this.idCardReader.selectCard(0);
            return true;
        }
        catch (IDCardReaderException e) {
            e.printStackTrace();
            return false;
        }
    }

    private class MyTask
    extends AsyncTask<Integer, Integer, Void> {
        IDCardInfo idCardInfo = null;
        boolean ret = false;
        long time = 0L;

        private MyTask() {
        }

        protected Void doInBackground(Integer ... param) {
            while (IdModule.this.bopen && IdModule.this.myTask != null && !IdModule.this.myTask.isCancelled()) {
                try {
                    IdModule.this.Authenticate();
                    this.idCardInfo = new IDCardInfo();
                    this.ret = IdModule.this.idCardReader.readCard(0, 1, this.idCardInfo);
                    this.publishProgress(new Integer[]{0});
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (IDCardReaderException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        protected void onProgressUpdate(Integer ... values) {
            super.onProgressUpdate((Object[])values);
            Log.e((String)"Task", (String)"onProgressUpdate: ");
            if (this.ret) {
                IdModule.this.readInfo(this.idCardInfo, this.ret);
            }
        }
    }
}

