/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.utils;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import com.zkteco.android.biometric.core.utils.LogHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ToolUtils {
    private static final char[] HexCode = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String bytesToHexString(byte[] bytes) {
        if (null == bytes) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            stringBuilder.append(HexCode[bytes[i] >>> 4 & 0xF]);
            stringBuilder.append(HexCode[bytes[i] & 0xF]);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static String bytesToHexString(byte[] bytes, int offset, int len) {
        if (null == bytes || offset < 0 || len <= 0 || offset + len > bytes.length) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(HexCode[bytes[offset + i] >>> 4 & 0xF]);
            stringBuilder.append(HexCode[bytes[offset + i] & 0xF]);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static void outputHexString(byte[] bytes) {
        if (LogHelper.getLevel() < 4) {
            LogHelper.d("outputHexString : " + ToolUtils.bytesToHexString(bytes));
        }
    }

    public static void outputHexString(byte[] bytes, int offset, int length) {
        if (LogHelper.getLevel() < 4) {
            LogHelper.d("outputHexString : " + ToolUtils.bytesToHexString(bytes, offset, length));
        }
    }

    public static Bitmap renderCroppedGreyScaleBitmap(byte[] buffer, int width, int height) {
        if (buffer == null || buffer.length == 0) {
            return null;
        }
        int[] pixels = new int[width * height];
        int inputOffset = 0;
        for (int y = 0; y < height; ++y) {
            int outputOffset = y * width;
            for (int x = 0; x < width; ++x) {
                int grey = buffer[inputOffset + x] & 0xFF;
                pixels[outputOffset + x] = 0xFF000000 | grey * 65793;
            }
            inputOffset += width;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        buffer = null;
        pixels = null;
        return bitmap;
    }

    public static Context getApplicationContext() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method method = activityThreadClass.getMethod("currentApplication", new Class[0]);
            Application app = (Application)method.invoke(null, (Object[])null);
            if (app != null) {
                return app.getApplicationContext();
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }
}

