/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device;

import android.content.Context;
import com.zkteco.android.biometric.core.device.ConfigurationInterface;
import com.zkteco.android.biometric.core.device.TransportInterface;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import java.util.HashMap;
import java.util.Map;

public abstract class TransportDevice
implements TransportInterface,
ConfigurationInterface {
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected Context context;

    public TransportDevice(Context context) {
        this.context = context;
    }

    @Override
    public int init() throws BiometricTransportException {
        return 0;
    }

    @Override
    public void open(int index) throws BiometricTransportException {
    }

    @Override
    public void control(int index, byte[] buffer, int length, int timeout) throws BiometricTransportException {
    }

    @Override
    public void controlEx(int index, int requestType, int request, int value, int addr, byte[] buffer, int length, int timeout) throws BiometricTransportException {
    }

    @Override
    public int read(int index, byte[] buffer, int length, int timeout) throws BiometricTransportException {
        return 0;
    }

    @Override
    public void write(int index, byte[] buffer, int length, int timeout) throws BiometricTransportException {
    }

    @Override
    public void close(int index) throws BiometricTransportException {
    }

    @Override
    public void free(int index) throws BiometricTransportException {
    }

    @Override
    public void addParameters(Map<String, Object> parameter) {
        this.parameters.putAll(parameter);
        LogHelper.i("Set parameters: " + this.parameters.toString());
    }

    @Override
    public void addParameter(String key, Object parameter) {
        this.parameters.put(key, parameter);
        LogHelper.i("Transport device add a parameter: [key=" + key + ", parameter=" + parameter + "]");
    }

    @Override
    public void removeParameter(String key) {
        this.parameters.remove(key);
        LogHelper.i("Transport device remove a parameter: [key=" + key + "]");
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
        LogHelper.i("Transport device has clear");
    }

    @Override
    public void destroy() {
    }

    @Override
    public void reset(int index) throws BiometricTransportException {
    }

    @Override
    public TransportType getType() {
        return TransportType.USB;
    }

    @Override
    public boolean isConnectExcepted() {
        return true;
    }

    public boolean SetConfigUsb(int index, int paramInt) {
        return true;
    }

    public void getUsbConnectionConfig(int index, int[] vid, int[] pid, int[] fd, int[] inPoint, int[] outPoint) {
    }
}

