/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.idcard.meta;

public class ICCardReaderRetData {
    private byte stx = (byte)-86;
    private byte stationid = 0;
    private byte len = 0;
    private byte status = (byte)-1;
    private byte[] data = null;
    private byte bcc = 0;
    private byte etx = (byte)-69;
    public static final int MIN_PACKET_LEN = 6;

    public void free() {
        this.stx = (byte)-86;
        this.stationid = 0;
        this.len = 0;
        this.data = null;
        this.status = (byte)-1;
        this.bcc = 0;
        this.etx = (byte)-69;
    }

    public byte getStatus() {
        return this.status;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataLen() {
        return this.len;
    }

    public int PreGetLen(byte[] buffer) {
        if (null == buffer || buffer.length < 6 || -86 != buffer[0]) {
            return 0;
        }
        return buffer[2] + 5;
    }

    public boolean UnPacket(byte[] buffer) {
        if (null == buffer || buffer.length < 6) {
            return false;
        }
        int nTotalLen = this.PreGetLen(buffer);
        if (nTotalLen <= 0 || nTotalLen > buffer.length || buffer[nTotalLen - 1] != -69) {
            return false;
        }
        int nPos = 0;
        this.stx = buffer[nPos++];
        this.stationid = buffer[nPos++];
        this.len = buffer[nPos++];
        this.status = buffer[nPos++];
        if (this.len > 1) {
            this.data = new byte[this.len - 1];
            System.arraycopy(buffer, nPos, this.data, 0, this.len - 1);
            nPos += this.len - 1;
        }
        this.bcc = buffer[nPos++];
        this.etx = buffer[nPos++];
        return true;
    }

    public byte getChecksum() {
        return this.bcc;
    }

    public byte calcCheckSum() {
        byte cs = 0;
        cs = (byte)(cs ^ this.stationid);
        cs = (byte)(cs ^ this.len);
        cs = (byte)(cs ^ this.status);
        if (null != this.data && this.data.length > 0) {
            for (int i = 0; i < this.data.length; ++i) {
                cs = (byte)(cs ^ this.data[i]);
            }
        }
        return cs;
    }
}

