/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.idcard.meta;

import com.zkteco.android.biometric.core.utils.LogHelper;

public class IDCardReaderSendData {
    byte len1 = 0;
    byte len2 = 0;
    byte cmd = 0;
    byte para = 0;
    byte[] data = null;
    byte checksum = 0;

    public void free() {
        this.checksum = 0;
        this.para = 0;
        this.cmd = 0;
        this.len2 = 0;
        this.len1 = 0;
        this.data = null;
    }

    public void setCmd(byte cmd) {
        this.cmd = cmd;
    }

    public void setPara(byte para) {
        this.para = para;
    }

    public void setData(byte[] data) {
        if (data != null && data.length > 0) {
            this.data = new byte[data.length];
            System.arraycopy(data, 0, this.data, 0, data.length);
        }
    }

    public int getPacketLen() {
        int length = 0;
        if (this.data != null && this.data.length > 0) {
            length += this.data.length;
        }
        LogHelper.d((String)("IDCardReader SendData getPacketLen length =" + (length += 10)));
        return length;
    }

    public int getHIDPacketLen() {
        int length = 0;
        if (this.data != null && this.data.length > 0) {
            length += this.data.length;
        }
        LogHelper.d((String)("IDCardReader SendData getPacketLen length =" + (length += 5)));
        return length;
    }

    public boolean packet(byte[] buffer) {
        int length = 3;
        int nPos = 0;
        this.checksum = 0;
        if (this.data != null && this.data.length > 0) {
            length += this.data.length;
        }
        this.len1 = (byte)((length & 0xFF00) >> 8);
        this.len2 = (byte)(length & 0xFF);
        this.checksum = (byte)(this.checksum ^ this.len1);
        this.checksum = (byte)(this.checksum ^ this.len2);
        this.checksum = (byte)(this.checksum ^ this.cmd);
        this.checksum = (byte)(this.checksum ^ this.para);
        if (this.data != null && this.data.length > 0) {
            for (int i = 0; i < this.data.length; ++i) {
                this.checksum = (byte)(this.checksum ^ this.data[i]);
            }
        }
        if (buffer == null || buffer.length < length + 7) {
            LogHelper.e((String)("IDCardReaderSendData unPacket fail, buffer length not enough, length=" + (length + 7)));
            return false;
        }
        buffer[0] = -86;
        buffer[1] = -86;
        buffer[2] = -86;
        buffer[3] = -106;
        buffer[4] = 105;
        buffer[5] = this.len1;
        buffer[6] = this.len2;
        buffer[7] = this.cmd;
        buffer[8] = this.para;
        nPos += 9;
        if (null != this.data && this.data.length > 0) {
            System.arraycopy(this.data, 0, buffer, nPos, this.data.length);
            nPos += this.data.length;
        }
        buffer[nPos] = this.checksum;
        return true;
    }

    public boolean packetHID(byte[] buffer) {
        int length = 3;
        int nPos = 0;
        this.checksum = 0;
        if (this.data != null && this.data.length > 0) {
            length += this.data.length;
        }
        this.len1 = (byte)((length & 0xFF00) >> 8);
        this.len2 = (byte)(length & 0xFF);
        this.checksum = (byte)(this.checksum ^ this.len1);
        this.checksum = (byte)(this.checksum ^ this.len2);
        this.checksum = (byte)(this.checksum ^ this.cmd);
        this.checksum = (byte)(this.checksum ^ this.para);
        if (this.data != null && this.data.length > 0) {
            for (int i = 0; i < this.data.length; ++i) {
                this.checksum = (byte)(this.checksum ^ this.data[i]);
            }
        }
        if (buffer == null || buffer.length < length + 7) {
            LogHelper.e((String)("IDCardReaderSendData unPacket fail, buffer length not enough, length=" + (length + 7)));
            return false;
        }
        buffer[0] = this.len1;
        buffer[1] = this.len2;
        buffer[2] = this.cmd;
        buffer[3] = this.para;
        nPos += 4;
        if (null != this.data && this.data.length > 0) {
            System.arraycopy(this.data, 0, buffer, nPos, this.data.length);
            nPos += this.data.length;
        }
        buffer[nPos] = this.checksum;
        return true;
    }
}

