/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usbscsi;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbManager;
import com.zkteco.android.biometric.core.utils.LogHelper;
import java.util.Map;

public class USBSCSIHandler {
    protected static final int USB_TYPE_STANDARD = 0;
    protected static final int USB_TYPE_CLASS = 32;
    protected static final int USB_TYPE_VENDOR = 64;
    protected static final int USB_TYPE_RESERVED = 96;
    protected static final int USB_RECIP_DEVICE = 0;
    protected static final int USB_RECIP_INTERFACE = 1;
    protected static final int USB_RECIP_ENDPOINT = 2;
    protected static final int USB_RECIP_OTHER = 3;
    private static final int DEFAULT_DEVICE_INDEX = -1;
    private static UsbManager usbManager = null;
    private static Map<String, UsbDevice> usbDeviceList = null;
    private static int currentDeviceIndex = -1;
    private Context context = null;
    private UsbDeviceConnection usbDeviceConnection = null;
    private UsbEndpoint inEndpoint = null;
    private UsbEndpoint outEndpoint = null;
    private String strSerialNumber = "";

    public USBSCSIHandler(Context context) {
        this.context = context;
    }

    public static void reset() {
        currentDeviceIndex = -1;
        usbDeviceList = null;
        usbManager = null;
    }

    public static int getCurrentDeviceIndex() {
        return currentDeviceIndex;
    }

    public static void setCurrentDeviceIndex(int currentDeviceIndex) {
        USBSCSIHandler.currentDeviceIndex = currentDeviceIndex;
    }

    public static UsbManager getUsbManager(Context context) {
        if (usbManager == null) {
            usbManager = (UsbManager)context.getSystemService("usb");
        }
        return usbManager;
    }

    public static Map<String, UsbDevice> getUSBDeviceList(Context context) {
        if (USBSCSIHandler.getUsbManager(context) != null) {
            usbDeviceList = usbManager.getDeviceList();
        } else {
            LogHelper.e("Get USBDeviceList failed because of USBManager is null!");
        }
        return usbDeviceList;
    }

    public UsbDeviceConnection getUsbDeviceConnection() {
        return this.usbDeviceConnection;
    }

    public void setUsbDeviceConnection(UsbDeviceConnection usbDeviceConnection) {
        this.usbDeviceConnection = usbDeviceConnection;
    }

    public UsbEndpoint getInEndpoint() {
        return this.inEndpoint;
    }

    public void setInEndpoint(UsbEndpoint inEndpoint) {
        this.inEndpoint = inEndpoint;
    }

    public UsbEndpoint getOutEndpoint() {
        return this.outEndpoint;
    }

    public void setOutEndpoint(UsbEndpoint outEndpoint) {
        this.outEndpoint = outEndpoint;
    }

    public void setStrSerialNumber(String serialNumber) {
        if (null != serialNumber) {
            this.strSerialNumber = serialNumber;
        }
    }

    public String getStrSerialNumber() {
        return this.strSerialNumber;
    }

    public int control(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        return this.usbDeviceConnection.controlTransfer(requestType, request, value, index, buffer, length, timeout);
    }

    public int control(byte[] buffer, int length, int timeout) {
        return -1;
    }

    public int read(byte[] buffer, int length, int timeout) {
        if (null == this.inEndpoint) {
            return -1;
        }
        return this.usbDeviceConnection.bulkTransfer(this.inEndpoint, buffer, length, timeout);
    }

    public int write(byte[] buffer, int length, int timeout) {
        if (null == this.outEndpoint) {
            return -1;
        }
        return this.usbDeviceConnection.bulkTransfer(this.outEndpoint, buffer, length, timeout);
    }

    public void close() {
        this.usbDeviceConnection.close();
    }
}

