/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usbhid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.text.TextUtils;
import com.zkteco.android.biometric.ZKUSBDeviceCtl;
import com.zkteco.android.biometric.core.device.TransportDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.device.usb.ZKUSBHOSTAPIService;
import com.zkteco.android.biometric.core.device.usbhid.USBHIDHandler;
import com.zkteco.android.biometric.core.device.usbhid.exception.USBHIDTransportException;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class USBHIDTransportDevice
extends TransportDevice {
    private List<USBHIDHandler> usbHandlerList = new ArrayList<USBHIDHandler>();
    private List<UsbDevice> filterUSBDeviceList = new ArrayList<UsbDevice>();
    private boolean mbConnectExcept = false;
    private int mCtlExceptCnt = 0;
    static final int MAX_CTL_EXCEPT_CNT = 10;
    private UsbInterface mUsbInterface = null;
    private static final int INTERFACE_SUBCLASS = 6;
    private static final int INTERFACE_PROTOCOL = 80;
    private ZKUSBHOSTAPIService mZKUSBHOSTAPIService = new ZKUSBHOSTAPIService();
    private Context mContext = null;
    private final String ACTION_USB_PERMISSION = "com.zkteco.android.biometric.core.device.usbscsi.USB_PERMISSION";
    private byte[] bufSend = new byte[64];
    private byte[] bufRecv = new byte[64];
    private BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("com.zkteco.android.biometric.core.device.usbscsi.USB_PERMISSION".equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    if (intent.getBooleanExtra("permission", false)) {
                        LogHelper.i("have permission!");
                    } else {
                        LogHelper.e("not permission!");
                    }
                }
            }
        }
    };

    int getString_descriptor(USBHIDHandler usbHandler, byte desc_index, short langid, byte[] data, int length) {
        return usbHandler.control(128, 6, 0x300 | desc_index, langid, data, length, 1000);
    }

    private String getUsbdescriptor_ascii(USBHIDHandler usbHandler, byte desc_index) {
        byte[] buffer = new byte[256];
        int r = this.getString_descriptor(usbHandler, (byte)0, (short)0, buffer, 256);
        if (r < 4) {
            LogHelper.e("getUsbdescriptor_ascii failed, ret:" + r);
            return "";
        }
        int langid = buffer[2] | buffer[3] << 8;
        r = this.getString_descriptor(usbHandler, desc_index, (short)langid, buffer, 256);
        if (r < 0) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, ret:" + r);
            return "";
        }
        if (buffer[1] != 3) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, no string");
            return "";
        }
        if (buffer[0] > r) {
            LogHelper.e("getUsbdescriptor_ascii2 failed, invalid length");
            return "";
        }
        int di = 0;
        int si = 0;
        byte[] data = new byte[128];
        di = 0;
        for (si = 2; si < buffer[0] && di < 127; si += 2) {
            data[di++] = buffer[si + 1] != 0 ? 63 : buffer[si];
        }
        LogHelper.i("getUsbdescriptor_ascii2 data length:" + di);
        return new String(data, 0, di);
    }

    public USBHIDTransportDevice(Context context) {
        super(context);
    }

    @Override
    public int init() throws USBHIDTransportException {
        if (null == this.context && null == (this.context = ToolUtils.getApplicationContext())) {
            throw USBHIDTransportException.initUSBDeviceFailed();
        }
        this.usbHandlerList.clear();
        this.filterUSBDeviceList.clear();
        this.filterUSBDevice();
        int usbCount = this.countValidDevice();
        if (usbCount > 0) {
            LogHelper.i("found " + usbCount + " devices");
            return usbCount;
        }
        throw USBHIDTransportException.initUSBDeviceFailed();
    }

    private void requestPermission(UsbDevice usbDevice) {
        this.mContext = this.context;
        UsbManager usbManager = (UsbManager)this.mContext.getSystemService("usb");
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.zkteco.android.biometric.core.device.usbscsi.USB_PERMISSION");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        this.mContext.registerReceiver(this.mUsbReceiver, filter);
        if (!usbManager.hasPermission(usbDevice)) {
            LogHelper.i("need request permission...");
            Intent intent = new Intent("com.zkteco.android.biometric.core.device.usbscsi.USB_PERMISSION");
            PendingIntent mIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            usbManager.requestPermission(usbDevice, mIntent);
        } else {
            LogHelper.i("has permission...");
        }
    }

    private void filterUSBDevice() {
        Map<String, UsbDevice> usbDeviceList = USBHIDHandler.getUSBDeviceList(this.context);
        int filterVID = (Integer)this.parameters.get("param.key.vid");
        int filterPID = (Integer)this.parameters.get("param.key.pid");
        for (UsbDevice device : usbDeviceList.values()) {
            int vid = device.getVendorId();
            int pid = device.getProductId();
            if (vid == filterVID && pid == filterPID) {
                this.filterUSBDeviceList.add(device);
                LogHelper.w("This usb device confirms with specific [VID=" + filterVID + ", PID=" + filterPID + "]\nDevice info: " + device.toString());
                continue;
            }
            LogHelper.w("Those usb device don't confirm with specific [VID=" + filterVID + ", PID=" + filterPID + "]\nDevice info: " + device.toString());
        }
    }

    public int countValidDevice() {
        return this.filterUSBDeviceList.size();
    }

    @Override
    public void open(int index) throws USBHIDTransportException {
        if (index >= this.countValidDevice()) {
            LogHelper.e("Invalid usb device " + index + " !");
            throw USBHIDTransportException.openInvaliedUSBDevice();
        }
        if (!this.startUSBHandler(index)) {
            throw USBHIDTransportException.openUSBDeviceFailed();
        }
    }

    private boolean startUSBHandler(int index) {
        UsbDevice usbDevice = this.filterUSBDeviceList.get(index);
        if (null == usbDevice) {
            LogHelper.e("invalid device!");
            return false;
        }
        UsbDeviceConnection usbDeviceConnection = USBHIDHandler.getUsbManager(this.context).openDevice(usbDevice);
        if (usbDeviceConnection == null) {
            LogHelper.e("Open usb device " + index + " failed because of USBDeviceConnection is null!");
            return false;
        }
        USBHIDHandler usbHandler = new USBHIDHandler(this.context);
        if (0 >= usbDevice.getInterfaceCount()) {
            LogHelper.e("Opening device " + index + " failed because of getInterfaceCount <= 0!");
            return false;
        }
        int interfaceCount = usbDevice.getInterfaceCount();
        for (int i = 0; i < interfaceCount; ++i) {
            UsbInterface usbInterface = usbDevice.getInterface(i);
            LogHelper.i("found usb interface: " + usbInterface);
            if (usbInterface.getInterfaceClass() != 3) {
                LogHelper.w("device interface not suitable!");
                continue;
            }
            int endpointCount = usbInterface.getEndpointCount();
            if (endpointCount != 2) {
                LogHelper.w("inteface endpoint count != 2");
            }
            UsbEndpoint outEndpoint = null;
            UsbEndpoint inEndpoint = null;
            for (int j = 0; j < endpointCount; ++j) {
                UsbEndpoint endpoint = usbInterface.getEndpoint(j);
                if (endpoint.getType() != 3) continue;
                if (endpoint.getDirection() == 0) {
                    outEndpoint = endpoint;
                    continue;
                }
                inEndpoint = endpoint;
            }
            LogHelper.w("inteface inEndpoint:" + inEndpoint + ",outEndpoint:" + outEndpoint);
            if (outEndpoint == null || inEndpoint == null) continue;
            String name = usbDevice.getDeviceName();
            String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
            int busnum = 0;
            int devnum = 0;
            if (v != null) {
                busnum = Integer.parseInt(v[v.length - 2]);
                devnum = Integer.parseInt(v[v.length - 1]);
            }
            this.mZKUSBHOSTAPIService.setUSBInfo(usbDevice.getVendorId(), usbDevice.getProductId(), usbDeviceConnection.getFileDescriptor(), busnum, devnum);
            usbHandler.setInEndpoint(inEndpoint);
            usbHandler.setOutEndpoint(outEndpoint);
            this.mZKUSBHOSTAPIService.setInEndpoint(usbHandler.getInEndpoint());
            this.mZKUSBHOSTAPIService.setOutEndpoint(usbHandler.getOutEndpoint());
            this.mZKUSBHOSTAPIService.setUSBDevConn(usbDeviceConnection);
            this.mUsbInterface = usbInterface;
        }
        if (usbHandler.getInEndpoint() == null || usbHandler.getOutEndpoint() == null) {
            LogHelper.e("Opening device " + index + " failed because of start USBHandler failed!");
            return false;
        }
        usbDeviceConnection.claimInterface(this.mUsbInterface, true);
        usbHandler.setUsbDeviceConnection(usbDeviceConnection);
        USBHIDHandler.setCurrentDeviceIndex(index);
        this.usbHandlerList.add(index, usbHandler);
        String strSerialNumber = "";
        strSerialNumber = this.getUsbdescriptor_ascii(usbHandler, (byte)3);
        usbHandler.setStrSerialNumber(strSerialNumber);
        LogHelper.i("Open usb device " + index + " OK");
        return true;
    }

    @Override
    public void control(int index, byte[] buffer, int length, int timeout) throws USBHIDTransportException {
        int ret;
        LogHelper.d("Start control USB device " + index);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(index)) {
            throw USBHIDTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBHIDTransportException.invalidBufferLength();
        }
        if (buffer != null && buffer.length > 0) {
            ToolUtils.outputHexString(buffer);
        }
        if ((ret = this.usbHandlerList.get(index).control(buffer, length, timeout)) < 0) {
            if (this.mCtlExceptCnt++ > 10) {
                this.mbConnectExcept = true;
            }
            LogHelper.e("Control USB device " + index + " failed!\nAndroid UsbDeviceConnection return ret is" + ret);
            throw USBHIDTransportException.controlUSBDeviceFailed(ret);
        }
        this.mbConnectExcept = false;
        this.mCtlExceptCnt = 0;
    }

    public void control(byte[] buffer, int length, int timeout) throws USBHIDTransportException {
        this.control(USBHIDHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void controlEx(int index, int requestType, int request, int value, int addr, byte[] buffer, int length, int timeout) throws USBHIDTransportException {
        int ret;
        LogHelper.d("Start control USB device Extension" + index);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(index)) {
            throw USBHIDTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBHIDTransportException.invalidBufferLength();
        }
        if (buffer != null && buffer.length > 0) {
            ToolUtils.outputHexString(buffer);
        }
        if ((ret = this.usbHandlerList.get(index).control(requestType, request, value, addr, buffer, length, timeout)) < 0) {
            if (this.mCtlExceptCnt++ > 10) {
                this.mbConnectExcept = true;
            }
            LogHelper.e("Control USB device " + index + " failed!\nAndroid UsbDeviceConnection return ret is" + ret);
            throw USBHIDTransportException.controlUSBDeviceFailed(ret);
        }
        this.mbConnectExcept = false;
        this.mCtlExceptCnt = 0;
    }

    public void controlEx(int requestType, int request, int value, int addr, byte[] buffer, int length, int timeout) throws USBHIDTransportException {
        this.controlEx(USBHIDHandler.getCurrentDeviceIndex(), requestType, request, value, addr, buffer, length, timeout);
    }

    private boolean isValidBufferLength(byte[] buffer, int length) throws USBHIDTransportException {
        if (null != buffer && buffer.length < length) {
            LogHelper.e("Buffer length is less than specified length!");
            return false;
        }
        return true;
    }

    @Override
    public int read(int index, byte[] buffer, int length, int timeout) throws USBHIDTransportException {
        LogHelper.d("Start read USB device " + index + ",length=" + length);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(index)) {
            throw USBHIDTransportException.operateInvalidUSBDevice();
        }
        int ret = 0;
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBHIDTransportException.invalidBufferLength();
        }
        long tickStart = System.currentTimeMillis();
        while ((ret = this.usbHandlerList.get(index).read(this.bufRecv, this.bufRecv.length, timeout)) <= 0 && System.currentTimeMillis() - tickStart < (long)timeout) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ret == -1) {
            LogHelper.w("Read USB device " + index + " timout!");
            return 0;
        }
        if (ret <= 0) {
            LogHelper.e("Read USB device " + index + " failed!Android UsbDeviceConnection return ret is " + ret);
            return 0;
        }
        System.arraycopy(this.bufRecv, 0, buffer, 0, ret);
        ToolUtils.outputHexString(buffer, 0, ret);
        return ret;
    }

    public int read(byte[] buffer, int length, int timeout) throws USBHIDTransportException {
        return this.read(USBHIDHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void write(int index, byte[] buffer, int length, int timeout) throws USBHIDTransportException {
        LogHelper.d("Start write USB device " + index);
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(index)) {
            throw USBHIDTransportException.operateInvalidUSBDevice();
        }
        if (!this.isValidBufferLength(buffer, length)) {
            throw USBHIDTransportException.invalidBufferLength();
        }
        ToolUtils.outputHexString(buffer, 0, length);
        int ret = this.usbHandlerList.get(index).write(buffer, length, timeout);
        if (ret <= 0) {
            LogHelper.e("Write USB device " + index + " failed!\nAndroid UsbDeviceConnection return ret is " + ret);
            throw USBHIDTransportException.writeUSBDeviceFailed(ret);
        }
    }

    public void write(byte[] buffer, int length, int timeout) throws USBHIDTransportException {
        this.write(USBHIDHandler.getCurrentDeviceIndex(), buffer, length, timeout);
    }

    @Override
    public void close(int index) throws USBHIDTransportException {
        if (this.usbHandlerList.size() > 0) {
            try {
                this.usbHandlerList.get(index).close();
            }
            catch (IndexOutOfBoundsException e) {
                LogHelper.e("Invalid index to close! Your invalid index is " + index);
                throw USBHIDTransportException.closeUSBTransportException(-9);
            }
        } else {
            LogHelper.w("No any working USB device, don't need to close");
        }
    }

    @Override
    public void free(int index) throws USBHIDTransportException {
        if (this.usbHandlerList.size() > 0) {
            try {
                this.usbHandlerList.remove(index);
            }
            catch (IndexOutOfBoundsException e) {
                LogHelper.e("Invalid index to free! Your invalid index is " + index);
                throw USBHIDTransportException.freeUSBDeviceFailed(-10);
            }
        } else {
            LogHelper.w("No any working USB device, don't need to free");
        }
    }

    @Override
    public void destroy() {
        if (this.usbHandlerList.size() > 0) {
            Iterator<USBHIDHandler> iterator = this.usbHandlerList.iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
            }
            this.usbHandlerList.clear();
        }
        USBHIDHandler.reset();
        this.filterUSBDeviceList.clear();
        this.parameters = null;
        this.context = null;
    }

    @Override
    public TransportType getType() {
        return TransportType.USBHID;
    }

    @Override
    public Object getConnectionService() {
        return this.mZKUSBHOSTAPIService;
    }

    @Override
    public void setCtlRetryFlag(boolean bFlag) {
    }

    @Override
    public String getSerialNumber(int index) {
        if (this.usbHandlerList.size() > 0) {
            return this.usbHandlerList.get(index).getStrSerialNumber();
        }
        return "";
    }

    @Override
    public boolean isConnectExcepted() {
        return this.mbConnectExcept;
    }

    @Override
    public void reset(int index) throws USBHIDTransportException {
        ZKUSBDeviceCtl.resetDevice(this.mZKUSBHOSTAPIService.getVendorID(), this.mZKUSBHOSTAPIService.getProductID(), this.mZKUSBHOSTAPIService.getFD(), this.mZKUSBHOSTAPIService.getBusNum(), this.mZKUSBHOSTAPIService.getDevAddr(), this.mZKUSBHOSTAPIService.getInEndPointAddr(), this.mZKUSBHOSTAPIService.getOutEndPointAddr());
    }

    @Override
    public void reset2(int index) throws BiometricTransportException {
        if (0 >= this.usbHandlerList.size() || null == this.usbHandlerList.get(index)) {
            throw USBHIDTransportException.operateInvalidUSBDevice();
        }
        this.controlEx(index, 64, 240, 0, 48, null, 0, 1000);
    }
}

