/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.serialport.exception;

import com.zkteco.android.biometric.core.exception.BiometricTransportException;

public class SerialPortTransportException
extends BiometricTransportException {
    private static final String INIT_SERIAL_DEVICE_FAILED = "Initialize serial device failed";
    private static final String INVALID_SERIAL_DEVICE_PARAMS = "Invalid serial device params";
    private static final String OPEN_SERIAL_DEVICE_FAIL = "Open serial device failed";
    private static final String METHOD_NOT_SUPPORT = "Method was not supported";
    private static final String DEVICE_NOT_OPENED = "Device was not opened";
    private static final String WRITE_FAILED = "Write buffer failed";
    private static final String READ_FAILED = "Read buffer failed";

    SerialPortTransportException(String message, int errorCode) {
        super(message, errorCode);
    }

    SerialPortTransportException(String message, int errorCode, int internalErrorCode) {
        super(message, errorCode, internalErrorCode);
    }

    public static SerialPortTransportException initSerialDeviceFailed() {
        return new SerialPortTransportException(INIT_SERIAL_DEVICE_FAILED, -1);
    }

    public static SerialPortTransportException invalidSerialDeviceParams() {
        return new SerialPortTransportException(INVALID_SERIAL_DEVICE_PARAMS, -2);
    }

    public static SerialPortTransportException openSerialDeviceFailed(String msg) {
        return new SerialPortTransportException(msg, -4);
    }

    public static SerialPortTransportException openSerialDeviceFailed() {
        return new SerialPortTransportException(OPEN_SERIAL_DEVICE_FAIL, -4);
    }

    public static SerialPortTransportException methodNotSupport() {
        return new SerialPortTransportException(METHOD_NOT_SUPPORT, -5);
    }

    public static SerialPortTransportException deviceNotOpened() {
        return new SerialPortTransportException(DEVICE_NOT_OPENED, -6);
    }

    public static SerialPortTransportException readFailed(String msg) {
        return new SerialPortTransportException(msg, -7);
    }

    public static SerialPortTransportException readFailed() {
        return new SerialPortTransportException(READ_FAILED, -7);
    }

    public static SerialPortTransportException writeFailed(String msg) {
        return new SerialPortTransportException(WRITE_FAILED, -8);
    }

    public static SerialPortTransportException writeFailed() {
        return new SerialPortTransportException(WRITE_FAILED, -8);
    }
}

