/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.idcard.meta;

import com.zkteco.android.biometric.core.utils.LogHelper;

public class IDCardReaderRetData {
    byte len1 = 0;
    byte len2 = 0;
    byte sw1 = 0;
    byte sw2 = 0;
    byte sw3 = 0;
    byte[] data = null;
    byte checksum = 0;
    public static final int min_len = 11;
    public static final int min_hid_len = 6;

    public void free() {
        this.checksum = 0;
        this.sw3 = 0;
        this.sw2 = 0;
        this.sw1 = 0;
        this.len2 = 0;
        this.len1 = 0;
        this.data = null;
    }

    public byte getSw1() {
        return this.sw1;
    }

    public byte getSw2() {
        return this.sw2;
    }

    public byte getSw3() {
        return this.sw3;
    }

    public byte getChecksum() {
        return this.checksum;
    }

    public byte calcCheckSum() {
        byte cs = 0;
        cs = (byte)(cs ^ this.len1);
        cs = (byte)(cs ^ this.len2);
        cs = (byte)(cs ^ this.sw1);
        cs = (byte)(cs ^ this.sw2);
        cs = (byte)(cs ^ this.sw3);
        if (null != this.data && this.data.length > 0) {
            for (int i = 0; i < this.data.length; ++i) {
                cs = (byte)(cs ^ this.data[i]);
            }
        }
        return cs;
    }

    public int getDataLen() {
        int length = 0;
        if (null != this.data) {
            length = this.data.length;
        }
        return length;
    }

    public void getData(byte[] buffer) {
        if (this.data != null && this.data.length > 0) {
            System.arraycopy(this.data, 0, buffer, 0, this.data.length);
        }
    }

    public int preGetDataLen(byte[] buffer) {
        int length = 0;
        if (null == buffer || buffer.length < 11 || buffer[0] != -86 || buffer[1] != -86 || buffer[2] != -86 || buffer[3] != -106 || buffer[4] != 105) {
            LogHelper.e((String)"invalid buffer1");
            return 0;
        }
        byte _len1 = buffer[5];
        byte _len2 = buffer[6];
        length += _len1 << 8 & 0xFF00;
        return (length += _len2) + 7;
    }

    public int preGetHIDDataLen(byte[] buffer) {
        int length = 0;
        if (null == buffer || buffer.length < 6) {
            LogHelper.e((String)"invalid buffer1");
            return 0;
        }
        byte _len1 = buffer[0];
        byte _len2 = buffer[1];
        length += _len1 << 8 & 0xFF00;
        return (length += _len2) + 2;
    }

    public boolean unPacket(byte[] buffer) {
        int length = 0;
        int nPos = 0;
        if (null == buffer || buffer.length < 11 || buffer[0] != -86 || buffer[1] != -86 || buffer[2] != -86 || buffer[3] != -106 || buffer[4] != 105) {
            LogHelper.e((String)"invalid buffer1");
            return false;
        }
        this.len1 = buffer[5];
        this.len2 = buffer[6];
        length += this.len1 << 8 & 0xFF00;
        if ((length += this.len2) + 7 > buffer.length) {
            LogHelper.e((String)"invalid buffer2");
            return false;
        }
        this.sw1 = buffer[7];
        this.sw2 = buffer[8];
        this.sw3 = buffer[9];
        nPos += 10;
        if (length > 4) {
            this.data = new byte[length - 4];
            System.arraycopy(buffer, nPos, this.data, 0, length - 4);
            nPos += length - 4;
        }
        this.checksum = buffer[nPos];
        return this.calcCheckSum() == this.checksum;
    }

    public boolean unPacketHID(byte[] buffer) {
        int length = 0;
        int nPos = 0;
        if (null == buffer || buffer.length < 6) {
            LogHelper.e((String)"invalid buffer1");
            return false;
        }
        this.len1 = buffer[0];
        this.len2 = buffer[1];
        length += this.len1 << 8 & 0xFF00;
        if ((length += this.len2) + 2 > buffer.length) {
            LogHelper.e((String)"invalid buffer2");
            return false;
        }
        this.sw1 = buffer[2];
        this.sw2 = buffer[3];
        this.sw3 = buffer[4];
        nPos += 5;
        if (length > 4) {
            this.data = new byte[length - 4];
            System.arraycopy(buffer, nPos, this.data, 0, length - 4);
            nPos += length - 4;
        }
        this.checksum = buffer[nPos];
        byte calcCheck = this.calcCheckSum();
        if (calcCheck != this.checksum) {
            LogHelper.e((String)("Unpack buffer failed, because checksum is incorrect, check-read=" + this.checksum + ",but check-calc=" + calcCheck));
            return false;
        }
        return true;
    }
}

