/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.util;

import com.zkteco.android.biometric.core.utils.LogHelper;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPort {
    private static final String TAG = "SerialPort";
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;
    private static final String DEFAULT_SU_PATH = "/system/bin/su";
    private static String sSuPath = "/system/bin/su";

    public static void setSuPath(String suPath) {
        if (suPath == null) {
            return;
        }
        sSuPath = suPath;
    }

    public boolean requireRootPermission(File device) {
        boolean bRet = false;
        try {
            Process su = Runtime.getRuntime().exec(sSuPath);
            String cmd = "chmod 666 " + device.getAbsolutePath() + "\n" + "exit\n";
            su.getOutputStream().write(cmd.getBytes());
            if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                LogHelper.e("request permission failed");
                bRet = false;
            } else {
                bRet = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogHelper.e(e.getMessage());
            bRet = false;
        }
        return true;
    }

    public SerialPort(File device, int baudrate) throws SecurityException, IOException {
        if (!(device.canRead() && device.canWrite() || this.requireRootPermission(device))) {
            SerialPort.setSuPath("/system/xbin/su");
            this.requireRootPermission(device);
        }
        this.mFd = this.open(device.getAbsolutePath(), baudrate);
        if (this.mFd == null) {
            throw new IOException();
        }
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
    }

    public InputStream getInputStream() {
        return this.mFileInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    private native FileDescriptor open(String var1, int var2);

    public native int close();

    static {
        System.loadLibrary("zkserialport");
    }
}

