/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;

public class ZKUSBHOSTAPIService {
    private UsbDeviceConnection mConnection = null;
    private UsbDevice mDevice = null;
    private UsbManager mUSBManager = null;
    private UsbEndpoint mInEndpoint = null;
    private UsbEndpoint mOutEndpoint = null;
    private UsbInterface mUSBInterface = null;
    private int mVendorID = 0;
    private int mProductID = 0;
    private int mFd = 0;
    private int mBusNum = 0;
    private int mDevAddr = 0;
    private int mInEndPointAddr = 0;
    private int mOutEndPointAddr = 0;

    public void setUSBInfo(int vid, int pid, int fd, int busNum, int devAddr) {
        this.mVendorID = vid;
        this.mProductID = pid;
        this.mFd = fd;
        this.mBusNum = busNum;
        this.mDevAddr = devAddr;
    }

    public int getVendorID() {
        return this.mVendorID;
    }

    public int getProductID() {
        return this.mProductID;
    }

    public int getFD() {
        return this.mFd;
    }

    public int getBusNum() {
        return this.mFd;
    }

    public int getDevAddr() {
        return this.mDevAddr;
    }

    public int getInEndPointAddr() {
        return this.mInEndPointAddr;
    }

    public int getOutEndPointAddr() {
        return this.mInEndPointAddr;
    }

    public void setInEndpoint(UsbEndpoint inEndpoint) {
        this.mInEndpoint = inEndpoint;
        if (null != inEndpoint) {
            this.mInEndPointAddr = inEndpoint.getAddress();
        }
    }

    public void setOutEndpoint(UsbEndpoint inEndpoint) {
        this.mOutEndpoint = inEndpoint;
        if (null != inEndpoint) {
            this.mOutEndPointAddr = inEndpoint.getAddress();
        }
    }

    public void setUSBDevConn(UsbDeviceConnection usbDevConn) {
        this.mConnection = usbDevConn;
    }

    public int control(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        return this.mConnection.controlTransfer(requestType, request, value, index, buffer, length, timeout);
    }

    public int read(byte[] buffer, int length, int timeout) {
        int ret = this.mConnection.bulkTransfer(this.mInEndpoint, buffer, length, timeout);
        LogHelper.i("length=" + length + ", read ret=" + ret);
        if (ret > 0) {
            ToolUtils.outputHexString(buffer);
        }
        return ret;
    }

    public int write(byte[] buffer, int length, int timeout) {
        if (null != buffer) {
            ToolUtils.outputHexString(buffer);
        }
        int ret = this.mConnection.bulkTransfer(this.mOutEndpoint, buffer, length, timeout);
        LogHelper.i("write ret=" + ret);
        return ret;
    }
}

