/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.hhserialport;

import android.content.Context;
import cn.pda.serialport.SerialPort;
import com.zkteco.android.biometric.core.device.TransportDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.device.serialport.exception.SerialPortTransportException;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HHSerialPortTransportDevice
extends TransportDevice {
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private int mBaudRate = 115200;
    private int mWaitOn = 0;
    private SerialPort serialPort = null;
    private String powerStr = "";
    private int mGpio = -1;
    private int index = 0;

    public HHSerialPortTransportDevice(Context context) {
        super(context);
    }

    @Override
    public int init() {
        int baudRate = (Integer)this.parameters.get("param.key.baudrate");
        if (baudRate > 0) {
            this.mBaudRate = baudRate;
        }
        return 1;
    }

    @Override
    public void open(int index) throws SerialPortTransportException {
        if (index < 0 || index > 64 || this.mBaudRate <= 0) {
            LogHelper.e("Invalid serialport params  !");
            throw SerialPortTransportException.invalidSerialDeviceParams();
        }
        this.index = index;
        try {
            this.serialPort = new SerialPort();
            this.serialPort = new SerialPort(index, this.mBaudRate, 0);
            this.mOutputStream = this.serialPort.getOutputStream();
            this.mInputStream = this.serialPort.getInputStream();
        }
        catch (Exception e) {
            this.serialPort = null;
            this.mOutputStream = null;
            this.mInputStream = null;
            LogHelper.e("open fail!, msg= " + e.getMessage());
            throw SerialPortTransportException.openSerialDeviceFailed(e.getMessage());
        }
        if (null == this.serialPort || null == this.mOutputStream || null == this.mInputStream) {
            LogHelper.e("opendevice fail!");
            throw SerialPortTransportException.openSerialDeviceFailed();
        }
    }

    @Override
    public void control(int index, byte[] buffer, int length, int timeout) throws SerialPortTransportException {
        LogHelper.e("Method not support!");
        throw SerialPortTransportException.methodNotSupport();
    }

    @Override
    public int read(int index, byte[] buffer, int length, int timeout) throws SerialPortTransportException {
        int ret = 0;
        if (null == this.serialPort || null == this.mInputStream) {
            LogHelper.e("Device not opened!");
            throw SerialPortTransportException.deviceNotOpened();
        }
        long nTickStart = System.currentTimeMillis();
        while (System.currentTimeMillis() - nTickStart < (long)timeout) {
            try {
                ret = this.mInputStream.read(buffer, 0, length);
                if (ret <= 0) continue;
                ToolUtils.outputHexString(buffer, 0, ret);
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                LogHelper.e("read fail, msg=" + e.getMessage() + " !");
            }
        }
        return ret;
    }

    @Override
    public void write(int index, byte[] buffer, int length, int timeout) throws SerialPortTransportException {
        if (null == this.serialPort || null == this.mOutputStream) {
            LogHelper.e("Device not opened!");
            throw SerialPortTransportException.deviceNotOpened();
        }
        try {
            this.mOutputStream.write(buffer, 0, length);
            LogHelper.i("write len:" + length);
            ToolUtils.outputHexString(buffer, 0, length);
        }
        catch (IOException e) {
            e.printStackTrace();
            LogHelper.e("write fail, msg=" + e.getMessage() + " !");
            throw SerialPortTransportException.writeFailed(e.getMessage());
        }
    }

    @Override
    public void close(int index) throws SerialPortTransportException {
        if (this.serialPort != null) {
            try {
                this.mInputStream.close();
                this.mOutputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.serialPort.close(index);
            this.serialPort = null;
        }
        this.serialPort = new SerialPort();
        String[] powers = this.powerStr.split(",");
        for (int i = 0; i < powers.length; ++i) {
            if ("3.3V".equals(powers[i])) {
                this.serialPort.power3v3off();
                continue;
            }
            if ("5V".equals(powers[i])) {
                this.serialPort.power_5Voff();
                continue;
            }
            if ("scan power".equals(powers[i])) {
                this.serialPort.scaner_poweroff();
                continue;
            }
            if ("psam power".equals(powers[i])) {
                this.serialPort.psam_poweroff();
                continue;
            }
            if (!"rfid power".equals(powers[i])) continue;
            this.serialPort.rfid_poweroff();
        }
        if (this.mGpio != -1) {
            this.serialPort.setGPIOlow(this.mGpio);
        }
        this.serialPort = null;
    }

    @Override
    public void free(int index) throws SerialPortTransportException {
    }

    @Override
    public void destroy() {
        try {
            this.close(this.index);
        }
        catch (SerialPortTransportException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reset2(int index) throws BiometricTransportException {
    }

    @Override
    public TransportType getType() {
        return TransportType.SERIALPORT;
    }

    @Override
    public Object getConnectionService() {
        return null;
    }

    @Override
    public void setCtlRetryFlag(boolean bFlag) {
    }

    @Override
    public String getSerialNumber(int index) {
        return "";
    }
}

