/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.module.idcard.meta;

import java.io.UnsupportedEncodingException;

public class IDCardInfo {
    private int cardType = 1;
    private int contentLength;
    private int photolength;
    private int fplength;
    private byte[] content;
    private byte[] photo;
    private byte[] fpdata;
    private static final String[] NATION_ARRAY = new String[]{"", "\u6c49", "\u8499\u53e4", "\u56de", "\u85cf", "\u7ef4\u543e\u5c14", "\u82d7", "\u5f5d", "\u58ee", "\u5e03\u4f9d", "\u671d\u9c9c", "\u6ee1", "\u4f97", "\u7476", "\u767d", "\u571f\u5bb6", "\u54c8\u5c3c", "\u54c8\u8428\u514b", "\u50a3", "\u9ece", "\u5088\u50f3", "\u4f64", "\u7572", "\u9ad8\u5c71", "\u62c9\u795c", "\u6c34", "\u4e1c\u4e61", "\u7eb3\u897f", "\u666f\u9887", "\u67ef\u5c14\u514b\u5b5c", "\u571f", "\u8fbe\u65a1\u5c14", "\u4eeb\u4f6c", "\u7f8c", "\u5e03\u6717", "\u6492\u62c9", "\u6bdb\u5357", "\u4ee1\u4f6c", "\u9521\u4f2f", "\u963f\u660c", "\u666e\u7c73", "\u5854\u5409\u514b", "\u6012", "\u4e4c\u5b5c\u522b\u514b", "\u4fc4\u7f57\u65af", "\u9102\u6e29\u514b", "\u5fb7\u6602", "\u4fdd\u5b89", "\u88d5\u56fa", "\u4eac", "\u5854\u5854\u5c14", "\u72ec\u9f99", "\u9102\u4f26\u6625", "\u8d6b\u54f2", "\u95e8\u5df4", "\u73de\u5df4", "\u57fa\u8bfa"};
    private String name;
    private String sex;
    private String nation;
    private String birth;
    private String address;
    private String id;
    private String depart;
    private String validityTime;
    private String passNum;
    private int visaTimes;
    private static final String BOY_CODE = "1";

    public void setCardType(int cardType) {
        this.cardType = cardType;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        byte[] buf = name.getBytes();
        int nLen = buf.length;
        for (int i = 0; i < nLen; ++i) {
            if (buf[i] != 0) continue;
            nLen = i;
            break;
        }
        this.name = nLen > 0 && nLen < buf.length ? new String(buf, 0, nLen) : name.trim();
        buf = null;
    }

    public String getBirth() {
        return this.birth;
    }

    private void setBirth(String birth) {
        this.birth = birth;
    }

    public String getId() {
        return this.id;
    }

    private void setId(String id) {
        this.id = id;
    }

    public String getAddress() {
        return this.address;
    }

    private void setAddress(String address) {
        byte[] buf = address.getBytes();
        int nLen = buf.length;
        for (int i = 0; i < nLen; ++i) {
            if (buf[i] != 0) continue;
            nLen = i;
            break;
        }
        this.address = nLen > 0 && nLen < buf.length ? new String(buf, 0, nLen) : address.trim();
        buf = null;
    }

    public String getDepart() {
        return this.depart;
    }

    private void setDepart(String depart) {
        byte[] buf = depart.getBytes();
        int nLen = buf.length;
        for (int i = 0; i < nLen; ++i) {
            if (buf[i] != 0) continue;
            nLen = i;
            break;
        }
        this.depart = nLen > 0 && nLen < buf.length ? new String(buf, 0, nLen) : depart.trim();
        buf = null;
    }

    public String getSex() {
        return this.sex;
    }

    private void setSex(String sex) {
        this.sex = sex;
    }

    public String getNation() {
        return this.nation;
    }

    private void setNation(String nation) {
        this.nation = nation;
    }

    public String getValidityTime() {
        return this.validityTime;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    private void setValidityTime(String validityTime) {
        this.validityTime = validityTime;
    }

    private String getSex(String sexCodeString) {
        if (sexCodeString.equals(BOY_CODE)) {
            return "\u7537";
        }
        return "\u5973";
    }

    private String getNation(String nationNumString) {
        int nationNum = Integer.parseInt(nationNumString);
        if (nationNum == 97) {
            return "\u5176\u4ed6";
        }
        if (nationNum == 98) {
            return "\u5916\u7c4d\u4eba\u58eb";
        }
        if (nationNum == 59) {
            return "\u7a7f\u9752\u4eba\u65cf";
        }
        if (0 < nationNum && nationNum <= 56) {
            return NATION_ARRAY[nationNum];
        }
        return "";
    }

    private String getBirthDay(String birthdayString) {
        return birthdayString.substring(0, 4) + "\u5e74" + birthdayString.substring(4, 6) + "\u6708" + birthdayString.substring(6, 8) + "\u65e5";
    }

    private String getValidityTime(String validityTimeString) {
        if (validityTimeString.indexOf("\u957f\u671f") != -1) {
            return validityTimeString.substring(0, 4) + "." + validityTimeString.substring(4, 6) + "." + validityTimeString.substring(6, 8) + "-" + "\u957f\u671f";
        }
        return validityTimeString.substring(0, 4) + "." + validityTimeString.substring(4, 6) + "." + validityTimeString.substring(6, 8) + "-" + validityTimeString.substring(8, 12) + "." + validityTimeString.substring(12, 14) + "." + validityTimeString.substring(14, 16);
    }

    private void setPassNum(String passNum) {
        byte[] buf = passNum.getBytes();
        int nLen = buf.length;
        for (int i = 0; i < nLen; ++i) {
            if (buf[i] != 0) continue;
            nLen = i;
            break;
        }
        this.passNum = nLen > 0 && nLen < buf.length ? new String(buf, 0, nLen) : passNum.trim();
        buf = null;
    }

    public String getPassNum() {
        return this.passNum;
    }

    private void setVisaTimes(String stimes) {
        this.visaTimes = Integer.parseInt(stimes);
    }

    public int getVisaTimes() {
        return this.visaTimes;
    }

    private void decodeIdCardBaseInfo(byte[] dataByte) throws UnsupportedEncodingException {
        String stringBuffer = new String(dataByte, "UTF16-LE");
        stringBuffer = new String(stringBuffer.getBytes("UTF-8"));
        this.setName(stringBuffer.substring(0, 15));
        this.setSex(this.getSex(stringBuffer.substring(15, 16)));
        if (1 == this.cardType) {
            this.setNation(this.getNation(stringBuffer.substring(16, 18)));
        }
        this.setBirth(this.getBirthDay(stringBuffer.substring(18, 26)));
        this.setAddress(stringBuffer.substring(26, 61));
        this.setId(stringBuffer.substring(61, 79).trim());
        this.setDepart(stringBuffer.substring(79, 94).trim());
        this.setValidityTime(this.getValidityTime(stringBuffer.substring(94, 110)));
        if (3 == this.cardType) {
            this.setPassNum(stringBuffer.substring(110, 119).trim());
            this.setVisaTimes(stringBuffer.substring(119, 121));
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public int getPhotolength() {
        return this.photolength;
    }

    public int getFplength() {
        return this.fplength;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getPhoto() {
        return this.photo;
    }

    public byte[] getFpdata() {
        return this.fpdata;
    }

    public void unPacket(byte[] buffer, int length) {
        this.contentLength = 0;
        this.photolength = 0;
        this.fplength = 0;
        if (length < 4) {
            return;
        }
        this.contentLength = buffer[0] << 8 & 0xFF00;
        this.contentLength += buffer[1];
        this.photolength = buffer[2] << 8 & 0xFF00;
        this.photolength += buffer[3];
        if (this.contentLength + this.photolength > length) {
            this.contentLength = 0;
            this.photolength = 0;
            return;
        }
        if (this.contentLength > 0) {
            this.content = new byte[this.contentLength];
            System.arraycopy(buffer, 4, this.content, 0, this.contentLength);
            try {
                this.decodeIdCardBaseInfo(this.content);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (this.photolength > 0) {
            this.photo = new byte[this.photolength];
            System.arraycopy(buffer, 4 + this.contentLength, this.photo, 0, this.photolength);
        }
    }

    public void unPacketExt(byte[] buffer, int length) {
        this.contentLength = 0;
        this.photolength = 0;
        this.fplength = 0;
        if (length < 6) {
            return;
        }
        this.contentLength = buffer[0] << 8 & 0xFF00;
        this.contentLength += buffer[1];
        this.photolength = buffer[2] << 8 & 0xFF00;
        this.photolength += buffer[3];
        this.fplength = buffer[4] << 8 & 0xFF00;
        this.fplength += buffer[5];
        if (this.contentLength + this.photolength + this.fplength > length) {
            this.contentLength = 0;
            this.photolength = 0;
            this.fplength = 0;
            return;
        }
        if (this.contentLength > 0) {
            this.content = new byte[this.contentLength];
            System.arraycopy(buffer, 6, this.content, 0, this.contentLength);
            try {
                this.decodeIdCardBaseInfo(this.content);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (this.photolength > 0) {
            this.photo = new byte[this.photolength];
            System.arraycopy(buffer, 6 + this.contentLength, this.photo, 0, this.photolength);
        }
        if (this.fplength > 0) {
            this.fpdata = new byte[this.fplength];
            System.arraycopy(buffer, 6 + this.contentLength + this.photolength, this.fpdata, 0, this.fplength);
        }
    }
}

