/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.serialport;

import android.content.Context;
import com.zkteco.android.biometric.core.device.TransportDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.device.serialport.exception.SerialPortTransportException;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import com.zkteco.android.util.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPortTransportDevice
extends TransportDevice {
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private int mBaudRate = 115200;
    private String mSerialName = null;
    private SerialPort serialPort = null;
    private int index = 0;

    public SerialPortTransportDevice(Context context) {
        super(context);
    }

    @Override
    public int init() {
        int baudRate = (Integer)this.parameters.get("param.key.baudrate");
        String strSerialName = (String)this.parameters.get("param.key.serialname");
        if (strSerialName == null || strSerialName == "") {
            return 0;
        }
        this.mSerialName = strSerialName;
        if (baudRate > 0) {
            this.mBaudRate = baudRate;
        }
        return 1;
    }

    @Override
    public void open(int index) throws SerialPortTransportException {
        if (null == this.mSerialName || "" == this.mSerialName || this.mBaudRate <= 0) {
            LogHelper.e("Invalid serialport params  !");
            throw SerialPortTransportException.invalidSerialDeviceParams();
        }
        this.index = index;
        try {
            this.serialPort = new SerialPort(new File(this.mSerialName), this.mBaudRate);
            this.mOutputStream = this.serialPort.getOutputStream();
            this.mInputStream = this.serialPort.getInputStream();
            try {
                long nTickStart = System.currentTimeMillis();
                while (System.currentTimeMillis() - nTickStart < 500L) {
                    int ret = this.mInputStream.available();
                    if (ret <= 0) continue;
                    nTickStart = System.currentTimeMillis();
                    byte[] bufRecv = new byte[ret];
                    this.mInputStream.read(bufRecv);
                }
            }
            catch (Exception e) {
            }
        }
        catch (Exception e) {
            this.serialPort = null;
            this.mOutputStream = null;
            this.mInputStream = null;
            LogHelper.e("open fail!, msg= " + e.getMessage());
            throw SerialPortTransportException.openSerialDeviceFailed(e.getMessage());
        }
        if (null == this.serialPort || null == this.mOutputStream || null == this.mInputStream) {
            LogHelper.e("opendevice fail!");
            throw SerialPortTransportException.openSerialDeviceFailed();
        }
    }

    @Override
    public void control(int index, byte[] buffer, int length, int timeout) throws SerialPortTransportException {
        LogHelper.e("Method not support!");
        throw SerialPortTransportException.methodNotSupport();
    }

    @Override
    public int read(int index, byte[] buffer, int length, int timeout) throws SerialPortTransportException {
        int ret = 0;
        if (null == this.serialPort || null == this.mInputStream) {
            LogHelper.e("Device not opened!");
            throw SerialPortTransportException.deviceNotOpened();
        }
        long nTickStart = System.currentTimeMillis();
        int nReadLen = length;
        while (nReadLen > 0 && System.currentTimeMillis() - nTickStart < (long)timeout) {
            try {
                ret = this.mInputStream.read(buffer, 0, nReadLen);
                if (ret <= 0) continue;
                ToolUtils.outputHexString(buffer, 0, ret);
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                LogHelper.e("read fail, msg=" + e.getMessage() + " !");
            }
        }
        return ret;
    }

    @Override
    public void write(int index, byte[] buffer, int length, int timeout) throws SerialPortTransportException {
        if (null == this.serialPort || null == this.mOutputStream) {
            LogHelper.e("Device not opened!");
            throw SerialPortTransportException.deviceNotOpened();
        }
        try {
            this.mOutputStream.write(buffer, 0, length);
            ToolUtils.outputHexString(buffer, 0, length);
        }
        catch (IOException e) {
            e.printStackTrace();
            LogHelper.e("write fail, msg=" + e.getMessage() + " !");
            throw SerialPortTransportException.writeFailed(e.getMessage());
        }
    }

    @Override
    public void close(int index) throws SerialPortTransportException {
        if (this.serialPort != null) {
            try {
                this.mInputStream.close();
                this.mOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serialPort.close();
            this.serialPort = null;
        }
    }

    @Override
    public void free(int index) throws SerialPortTransportException {
    }

    @Override
    public void destroy() {
        try {
            this.close(this.index);
        }
        catch (SerialPortTransportException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reset2(int index) throws BiometricTransportException {
    }

    @Override
    public TransportType getType() {
        return TransportType.SERIALPORT;
    }

    @Override
    public Object getConnectionService() {
        return null;
    }

    @Override
    public void setCtlRetryFlag(boolean bFlag) {
    }

    @Override
    public String getSerialNumber(int index) {
        return "";
    }
}

