/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import com.zkteco.android.biometric.core.device.TransportDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.device.bluetooth.exception.BHTTransportException;
import com.zkteco.android.biometric.core.exception.BiometricTransportException;
import com.zkteco.android.biometric.core.utils.LogHelper;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class BHTTransportDevice
extends TransportDevice {
    private BluetoothAdapter mBluetoothAdapter = null;
    private BluetoothSocket mBluetoothSocket;
    public static final UUID myuuid = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private String mMac = null;
    protected Object deviceLock = new Object();

    public BHTTransportDevice(Context context) {
        super(context);
    }

    @Override
    public int init() {
        String strMac = (String)this.parameters.get("param.key.BHT.mac");
        if (strMac == null || strMac.length() <= 0) {
            return 0;
        }
        this.mMac = strMac;
        return 1;
    }

    @Override
    public void open(int index) throws BHTTransportException {
        if (null == this.mMac) {
            LogHelper.e("Invalid serialport params  !");
            throw BHTTransportException.invalidBHTDeviceParams();
        }
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (null == this.mBluetoothAdapter) {
            LogHelper.e("null adapter");
            throw BHTTransportException.openBHTDeviceFailed("null adapter", -9);
        }
        if (!this.mBluetoothAdapter.isEnabled()) {
            throw BHTTransportException.openBHTDeviceFailed("bluetooth was disabled", -10);
        }
        BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(this.mMac);
        if (null == device) {
            LogHelper.e("getRemoteDevice failed, mac=" + this.mMac);
            throw BHTTransportException.openBHTDeviceFailed("getRemoteDevice failed, mac=" + this.mMac, -11);
        }
        try {
            this.mBluetoothSocket = device.createRfcommSocketToServiceRecord(myuuid);
            this.mBluetoothSocket.connect();
            this.mInputStream = this.mBluetoothSocket.getInputStream();
            this.mOutputStream = this.mBluetoothSocket.getOutputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mBluetoothSocket = null;
            this.mInputStream = null;
            this.mOutputStream = null;
            LogHelper.e("createRfcommSocketToServiceRecord or connect exception, msg=" + e.getMessage());
            throw BHTTransportException.openBHTDeviceFailed("connectdevice failed", -12);
        }
    }

    @Override
    public void control(int index, byte[] buffer, int length, int timeout) throws BHTTransportException {
        if (null == this.mOutputStream) {
            LogHelper.e("Device not opened!");
            throw BHTTransportException.deviceNotOpened();
        }
        try {
            this.mOutputStream.write(buffer, 0, length);
            ToolUtils.outputHexString(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            LogHelper.e("write fail, msg=" + e.getMessage() + " !");
            throw BHTTransportException.writeFailed(e.getMessage());
        }
    }

    @Override
    public int read(int index, byte[] buffer, int length, int timeout) throws BHTTransportException {
        int ret = 0;
        if (null == this.mInputStream) {
            LogHelper.e("Device not opened!");
            throw BHTTransportException.deviceNotOpened();
        }
        long nTickStart = System.currentTimeMillis();
        while (System.currentTimeMillis() - nTickStart < (long)timeout) {
            try {
                int nReadLen = 0;
                nReadLen = this.mInputStream.available();
                if (nReadLen > length) {
                    nReadLen = length;
                }
                if (nReadLen <= 0 || (ret = this.mInputStream.read(buffer, 0, nReadLen)) <= 0) continue;
                ToolUtils.outputHexString(buffer);
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                LogHelper.e("read fail, msg=" + e.getMessage() + " !");
            }
        }
        return ret;
    }

    @Override
    public void write(int index, byte[] buffer, int length, int timeout) throws BHTTransportException {
        if (null == this.mOutputStream) {
            LogHelper.e("Device not opened!");
            throw BHTTransportException.deviceNotOpened();
        }
        try {
            this.mOutputStream.write(buffer, 0, length);
            ToolUtils.outputHexString(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            LogHelper.e("write fail, msg=" + e.getMessage() + " !");
            throw BHTTransportException.writeFailed(e.getMessage());
        }
    }

    @Override
    public void close(int index) throws BHTTransportException {
        if (this.mBluetoothSocket != null) {
            if (null != this.mOutputStream) {
                try {
                    this.mOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.mOutputStream = null;
            if (null != this.mInputStream) {
                try {
                    this.mInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.mInputStream = null;
            if (null != this.mBluetoothSocket) {
                try {
                    this.mBluetoothSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.mBluetoothSocket = null;
            }
        }
    }

    @Override
    public void free(int index) throws BHTTransportException {
    }

    @Override
    public void destroy() {
        try {
            this.close(0);
        }
        catch (BHTTransportException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reset2(int index) throws BiometricTransportException {
    }

    @Override
    public TransportType getType() {
        return TransportType.BLUETOOTH;
    }

    @Override
    public Object getConnectionService() {
        return null;
    }

    @Override
    public void setCtlRetryFlag(boolean bFlag) {
    }

    @Override
    public String getSerialNumber(int index) {
        return "";
    }
}

