/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.usbhid.exception;

import com.zkteco.android.biometric.core.exception.BiometricTransportException;

public class USBHIDTransportException
extends BiometricTransportException {
    private static final String INIT_USB_DEVICE_FAILED = "Initialize USB device failed";
    private static final String OPEN_INVALID_USB_DEVICE = "Try to open a invalid USB device";
    private static final String OPEN_DEVICE_FAILED = "Open USB device failed";
    private static final String INVALID_BUFFER_LENGTH = "Invalid buffer length, buffer length is less than specified length";
    private static final String CONTROL_INVALID_USB_DEVICE = "Control invalid USB device";
    private static final String CONTROL_USB_DEVICE_FAILED = "Control USB device failed";
    private static final String READ_USB_DEVICE_FAILED = "Read USB device failed";
    private static final String WRITE_USB_DEVICE_FAILED = "Write USB device failed";
    private static final String CLOSE_USB_DEVICE_FAILED = "Close USB device failed";
    private static final String FREE_USB_DEVICE_FAILED = "Free USB device failed";

    USBHIDTransportException(String message, int errorCode) {
        super(message, errorCode);
    }

    USBHIDTransportException(String message, int errorCode, int internalErrorCode) {
        super(message, errorCode, internalErrorCode);
    }

    public static USBHIDTransportException initUSBDeviceFailed() {
        return new USBHIDTransportException(INIT_USB_DEVICE_FAILED, -1);
    }

    public static USBHIDTransportException openInvaliedUSBDevice() {
        return new USBHIDTransportException(OPEN_INVALID_USB_DEVICE, -2);
    }

    public static USBHIDTransportException openUSBDeviceFailed() {
        return new USBHIDTransportException(OPEN_DEVICE_FAILED, -3);
    }

    public static USBHIDTransportException operateInvalidUSBDevice() {
        return new USBHIDTransportException(CONTROL_INVALID_USB_DEVICE, -5);
    }

    public static USBHIDTransportException invalidBufferLength() {
        return new USBHIDTransportException(INVALID_BUFFER_LENGTH, -4);
    }

    public static USBHIDTransportException controlUSBDeviceFailed(int internalErrorCode) {
        return new USBHIDTransportException(CONTROL_USB_DEVICE_FAILED, -6, internalErrorCode);
    }

    public static USBHIDTransportException readUSBDeviceFailed(int internalErrorCode) {
        return new USBHIDTransportException(READ_USB_DEVICE_FAILED, -7, internalErrorCode);
    }

    public static USBHIDTransportException writeUSBDeviceFailed(int internalErrorCode) {
        return new USBHIDTransportException(WRITE_USB_DEVICE_FAILED, -8, internalErrorCode);
    }

    public static USBHIDTransportException closeUSBTransportException(int errorCode) {
        return new USBHIDTransportException(CLOSE_USB_DEVICE_FAILED, errorCode);
    }

    public static USBHIDTransportException freeUSBDeviceFailed(int errorCode) {
        return new USBHIDTransportException(FREE_USB_DEVICE_FAILED, errorCode);
    }
}

