/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.biometric.core.device.bluetooth.exception;

import com.zkteco.android.biometric.core.exception.BiometricTransportException;

public class BHTTransportException
extends BiometricTransportException {
    private static final String INIT_BHT_DEVICE_FAILED = "Initialize bluetooth device failed";
    private static final String INVALID_BHT_DEVICE_PARAMS = "Invalid bluetooth device params";
    private static final String OPEN_BHT_DEVICE_FAIL = "Open bluetooth device failed";
    private static final String METHOD_NOT_SUPPORT = "Method was not supported";
    private static final String DEVICE_NOT_OPENED = "Device was not opened";
    private static final String WRITE_FAILED = "Write buffer failed";
    private static final String READ_FAILED = "Read buffer failed";

    BHTTransportException(String message, int errorCode) {
        super(message, errorCode);
    }

    BHTTransportException(String message, int errorCode, int internalErrorCode) {
        super(message, errorCode, internalErrorCode);
    }

    public static BHTTransportException initBHTDeviceFailed() {
        return new BHTTransportException(INIT_BHT_DEVICE_FAILED, -1);
    }

    public static BHTTransportException invalidBHTDeviceParams() {
        return new BHTTransportException(INVALID_BHT_DEVICE_PARAMS, -2);
    }

    public static BHTTransportException openBHTDeviceFailed(String msg) {
        return new BHTTransportException(msg, -4);
    }

    public static BHTTransportException openBHTDeviceFailed(String msg, int internalErrorCode) {
        return new BHTTransportException(msg, -4, internalErrorCode);
    }

    public static BHTTransportException openBHTDeviceFailed() {
        return new BHTTransportException(OPEN_BHT_DEVICE_FAIL, -4);
    }

    public static BHTTransportException methodNotSupport() {
        return new BHTTransportException(METHOD_NOT_SUPPORT, -5);
    }

    public static BHTTransportException deviceNotOpened() {
        return new BHTTransportException(DEVICE_NOT_OPENED, -6);
    }

    public static BHTTransportException readFailed(String msg) {
        return new BHTTransportException(msg, -7);
    }

    public static BHTTransportException readFailed() {
        return new BHTTransportException(READ_FAILED, -7);
    }

    public static BHTTransportException writeFailed(String msg) {
        return new BHTTransportException(WRITE_FAILED, -8);
    }

    public static BHTTransportException writeFailed() {
        return new BHTTransportException(WRITE_FAILED, -8);
    }
}

